/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.block_entity;

import dev.doctor4t.wathe.block.DoorPartBlock;
import dev.doctor4t.wathe.block.SmallDoorBlock;
import dev.doctor4t.wathe.block_entity.SmallDoorBlockEntity;
import dev.doctor4t.wathe.block_entity.SyncingBlockEntity;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.index.WatheSounds;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_7094;
import net.minecraft.class_7225;

public abstract class DoorBlockEntity
extends SyncingBlockEntity {
    public class_7094 state = new class_7094();
    protected long lastUpdate = 0L;
    protected boolean open;
    protected int age = 0;
    private String keyName = "";
    private int closeCountdown = 0;
    private int jammedTime = 0;
    private boolean blasted = false;

    public DoorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.open = (Boolean)state.method_11654((class_2769)class_2741.field_12537);
        this.state.method_41322(this.age);
        this.state.method_56988(10, 1.0f);
    }

    public static <T extends DoorBlockEntity> void clientTick(class_1937 world, class_2338 pos, class_2680 state, T entity) {
        ++entity.age;
    }

    public static <T extends DoorBlockEntity> void serverTick(class_1937 world, class_2338 pos, class_2680 state, T entity) {
        if (((Boolean)state.method_11654((class_2769)DoorPartBlock.OPEN)).booleanValue() && !entity.isBlasted()) {
            entity.setCloseCountdown(entity.getCloseCountdown() - 1);
            if (entity.getCloseCountdown() <= 0) {
                SmallDoorBlock.toggleDoor(state, world, (SmallDoorBlockEntity)entity, pos);
            }
        } else {
            entity.setCloseCountdown(0);
        }
        if (entity.isJammed()) {
            entity.setJammed(entity.getJammedTime() - 1);
        }
    }

    public void toggle(boolean silent) {
        if (this.field_11863 == null || this.field_11863.method_8510() == this.lastUpdate || this.isBlasted()) {
            return;
        }
        this.toggleOpen();
        if (!silent) {
            this.playToggleSound();
        }
        this.toggleBlocks();
    }

    protected void toggleOpen() {
        if (this.field_11863 != null) {
            this.lastUpdate = this.field_11863.method_8510();
            this.open = !this.open;
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.open ? 1 : 0);
            this.closeCountdown = this.open ? GameConstants.DOOR_AUTOCLOSE_TIME : 0;
        }
    }

    protected void playToggleSound() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8396(null, this.field_11867, WatheSounds.BLOCK_DOOR_TOGGLE, class_3419.field_15245, 1.0f, 1.0f);
    }

    protected abstract void toggleBlocks();

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public float getYaw() {
        return 180.0f - this.getFacing().method_10144();
    }

    public class_2350 getFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    public int getAge() {
        return this.age;
    }

    public boolean method_11004(int type, int data) {
        if (this.field_11863 != null && type == 1) {
            this.state.method_41322(this.age);
            this.open = data != 0;
            return true;
        }
        return super.method_11004(type, data);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("open", this.isOpen());
        nbt.method_10556("blasted", this.isBlasted());
        nbt.method_10569("closeCountdown", this.getCloseCountdown());
        nbt.method_10569("jammedTime", this.getJammedTime());
        nbt.method_10582("keyName", this.getKeyName());
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.setOpen(nbt.method_10577("open"));
        this.setBlasted(nbt.method_10577("blasted"));
        this.setCloseCountdown(nbt.method_10550("closeCountdown"));
        this.setJammed(nbt.method_10550("jammedTime"));
        this.setKeyName(nbt.method_10558("keyName"));
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String string) {
        this.keyName = string;
    }

    public int getCloseCountdown() {
        return this.closeCountdown;
    }

    public void setCloseCountdown(int closeCountdown) {
        this.closeCountdown = closeCountdown;
    }

    public void setJammed(int time) {
        this.jammedTime = time;
    }

    public void jam() {
        this.setJammed(GameConstants.JAMMED_DOOR_TIME);
        if (this.open) {
            this.toggle(false);
        }
    }

    public void blast() {
        if (!this.open) {
            this.toggle(false);
        }
        this.setBlasted(true);
    }

    public boolean isJammed() {
        return this.jammedTime > 0;
    }

    public int getJammedTime() {
        return this.jammedTime;
    }

    public boolean isBlasted() {
        return this.blasted;
    }

    public void setBlasted(boolean blasted) {
        this.blasted = blasted;
    }
}

